/*____________________________________________________________________________
	pgpRandomPoolPriv.h
	
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	Random pool and dummy random pool, used globally.

	$Id: pgpRandomPoolPriv.h,v 1.6 2001/02/06 23:09:21 hal Exp $
____________________________________________________________________________*/
#ifndef Included_pgpRandomPoolPriv_h
#define Included_pgpRandomPoolPriv_h

#include "pgpRandomPool.h"
#include "pgpRandomContext.h"


PGP_BEGIN_C_DECLARATIONS


PGPError		pgpInitGlobalRandomPool( void );
PGPError		pgpCleanupGlobalRandomPool( void );
void			pgpInitGlobalRandomPoolContext( PGPRandomContext *rc );

/* one could create multiple instances of the global random pool */
PGPRandomVTBL const *	pgpGetGlobalRandomPoolVTBL( void );
PGPRandomVTBL const *	pgpGetGlobalDummyRandomPoolVTBL( void );


/* Entry points from back-end RPC */
PGPError		 	pgpGlobalRandomPoolAddState_internal(
						PGPBoolean addKeyState, PGPInt32 keyEvent,
						PGPBoolean addMouseState, PGPBoolean addSystemState );

PGPError			pgpGlobalRandomPoolGetInfo_internal(
						PGPUInt32 *entropy, PGPUInt32 *size,
						PGPUInt32 *minEntropy, PGPBoolean *hasMinEntropy,
						PGPBoolean *hasIntelRNG );



PGP_END_C_DECLARATIONS

#endif /* Included_pgpRandomPoolPriv_h */
